/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.tuple;

import io.gitlab.jfronny.commons.tuple.Quadruple;
import io.gitlab.jfronny.commons.tuple.Single;
import io.gitlab.jfronny.commons.tuple.Triple;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Tuple<T1, T2>(@Nullable T1 left, @Nullable T2 right) {
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T1> Single<T1> of(@Nullable T1 val) {
        return new Single<T1>(val);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <T1, T2> Tuple<T1, T2> of(@Nullable T1 left, @Nullable T2 right) {
        return new Tuple<T1, T2>(left, right);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <T1, T2, T3> Triple<T1, T2, T3> of(@Nullable T1 val1, @Nullable T2 val2, @Nullable T3 val3) {
        return new Triple<T1, T2, T3>(val1, val2, val3);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static <T1, T2, T3, T4> Quadruple<T1, T2, T3, T4> of(@Nullable T1 val1, @Nullable T2 val2, @Nullable T3 val3, @Nullable T4 val4) {
        return new Quadruple<T1, T2, T3, T4>(val1, val2, val3, val4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T1, T2> Tuple<T1, T2> from(@NotNull Map.Entry<T1, T2> entry) {
        Objects.requireNonNull(entry);
        return new Tuple<T1, T2>(entry.getKey(), entry.getValue());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Tuple<T, T2> mapLeft(@NotNull Function<T1, T> mapper) {
        return new Tuple<T, T2>(Objects.requireNonNull(mapper).apply(this.left), this.right);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T1, T2, T> Function<Tuple<T1, T2>, Tuple<T, T2>> mappingLeft(@NotNull Function<T1, T> mapper) {
        return tuple -> tuple.mapLeft(mapper);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Tuple<T1, T> mapRight(@NotNull Function<T2, T> mapper) {
        return new Tuple<T1, T>(this.left, Objects.requireNonNull(mapper).apply(this.right));
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T1, T2, T> Function<Tuple<T1, T2>, Tuple<T1, T>> mappingRight(@NotNull Function<T2, T> mapper) {
        return tuple -> tuple.mapRight(mapper);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Tuple<T2, T1> swap() {
        return new Tuple<T2, T1>(this.right, this.left);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T3> Triple<T1, T2, T3> concat(@Nullable T3 val3) {
        return Triple.of(this.left, this.right, val3);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public <T3, T4> Quadruple<T1, T2, T3, T4> concat(@Nullable T3 val3, @Nullable T4 val4) {
        return Quadruple.of(this.left, this.right, val3, val4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T3> Triple<T1, T2, T3> concat(@NotNull Single<T3> val3) {
        return Triple.of(this.left, this.right, val3.val());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T3, T4> Quadruple<T1, T2, T3, T4> concat(@NotNull Tuple<T3, T4> val3) {
        return Quadruple.of(this.left, this.right, val3.left(), val3.right());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T1, T2> Set<Tuple<T1, T2>> from(final @NotNull Map<T1, T2> map) {
        Objects.requireNonNull(map);
        return new AbstractSet<Tuple<T1, T2>>(){

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public boolean isEmpty() {
                return map.isEmpty();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean contains(Object o) {
                Object left;
                Object object;
                if (!(o instanceof Tuple)) return map.containsKey(o);
                Tuple tuple = (Tuple)o;
                try {
                    left = object = tuple.left();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Object right = object = tuple.right();
                if (!map.containsKey(left) || map.get(left) != right) return map.containsKey(o);
                return true;
            }

            @Override
            @NotNull
            public Iterator<Tuple<T1, T2>> iterator() {
                return map.entrySet().stream().map(Tuple::from).iterator();
            }

            @Override
            @NotNull
            public @NotNull Object @NotNull [] toArray() {
                return map.entrySet().stream().map(Tuple::from).toArray();
            }

            @Override
            public boolean add(Tuple<T1, T2> t1T2Tuple) {
                return map.put(t1T2Tuple.left, t1T2Tuple.right) == null;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean remove(Object o) {
                if (o instanceof Tuple) {
                    Tuple tuple = (Tuple)o;
                    try {
                        Object object;
                        Object left = object = tuple.left();
                        Object right = object = tuple.right();
                        return map.remove(left, right);
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                if (map.remove(o) == null) return false;
                return true;
            }

            @Override
            public void clear() {
                map.clear();
            }
        };
    }

    public <R> R accept(BiFunction<T1, T2, R> acceptor) {
        return acceptor.apply(this.left, this.right);
    }

    public static <T1, T2, R> Function<Tuple<T1, T2>, R> accepting(BiFunction<T1, T2, R> acceptor) {
        return tuple -> tuple.accept(acceptor);
    }

    public static <T1, T2, A1, A2, R1, R2> Collector<Tuple<T1, T2>, Tuple<A1, A2>, Tuple<R1, R2>> collector(final Collector<T1, A1, R1> left, final Collector<T2, A2, R2> right) {
        return new Collector<Tuple<T1, T2>, Tuple<A1, A2>, Tuple<R1, R2>>(){

            @Override
            public Supplier<Tuple<A1, A2>> supplier() {
                Supplier leftSupplier = left.supplier();
                Supplier rightSupplier = right.supplier();
                return () -> Tuple.of(leftSupplier.get(), rightSupplier.get());
            }

            @Override
            public BiConsumer<Tuple<A1, A2>, Tuple<T1, T2>> accumulator() {
                BiConsumer leftAccumulator = left.accumulator();
                BiConsumer rightAccumulator = right.accumulator();
                return (a, b) -> {
                    leftAccumulator.accept(a.left, b.left);
                    rightAccumulator.accept(a.right, b.right);
                };
            }

            @Override
            public BinaryOperator<Tuple<A1, A2>> combiner() {
                BinaryOperator leftCombiner = left.combiner();
                BinaryOperator rightCombiner = right.combiner();
                return (a, b) -> Tuple.of(leftCombiner.apply(a.left, b.left), rightCombiner.apply(a.right, b.right));
            }

            @Override
            public Function<Tuple<A1, A2>, Tuple<R1, R2>> finisher() {
                Function leftFinisher = left.finisher();
                Function rightFinisher = right.finisher();
                return a -> Tuple.of(leftFinisher.apply(a.left), rightFinisher.apply(a.right));
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                HashSet<Collector.Characteristics> characteristics = new HashSet<Collector.Characteristics>(left.characteristics());
                characteristics.retainAll(right.characteristics());
                return characteristics;
            }
        };
    }
}

